class rectangle {

  int w;
  int h;
  int l;
  int t;
  float offsetX = 0;
  float offsetY = 0;
  PVector pos;
  PVector worldPos;
  float xspeed, yspeed;
  rectangle parent;
  
  float speed = (0.03);

  rectangle(rectangle P, int W, int H, int L, int T) {

    parent = P;
    w = W;
    h = H;
    l = L;
    t = T;
    pos = new PVector(w/2, h/2);
    worldPos = new PVector(0, 0);
    set_speeds();
  }  

  void update() {

    pos.x += xspeed;
    pos.y += yspeed;

    if (pos.x + l/2 > w || pos.x -l/2 < 0) {
      xspeed *= -1;
    }

    if (pos.y + t/2 > h || pos.y -t/2 < 0) {
      yspeed *= -1;
    }

    if (parent != null) {
      PVector tempPos = new PVector(0, 0);
      tempPos.x += (parent.worldPos.x - pos.x) + w/2;
      tempPos.y += (parent.worldPos.y - pos.y) + h/2;
      worldPos = tempPos;
    } 
    else worldPos = pos;
  }

  void set_speeds(){
  xspeed = random(-speed, speed);
  yspeed = random(-speed, speed);
  }
 

  void render() {
    if(debug)  rect(worldPos.x, worldPos.y, l, t);
    if(parent != null){
    line(worldPos.x, worldPos.y, parent.worldPos.x, parent.worldPos.y);
    }
    
    point(int(worldPos.x), int(worldPos.y));
   
  }
}

